

-- Table: public.tip_uplate
DROP TABLE IF EXISTS public.upis;
DROP TABLE IF EXISTS public.poslednja_izmena;
DROP TABLE IF EXISTS public.mesto;
DROP TABLE IF EXISTS public.opstina;
DROP TABLE IF EXISTS public.skolska_godina;
DROP TABLE IF EXISTS public.profil;
DROP TABLE IF EXISTS public.datum;
DROP TABLE IF EXISTS public.nacin_upisa;
DROP TABLE IF EXISTS public.godina_studija;



-- SEQUENCE: public.datum_id_seq

DROP SEQUENCE IF EXISTS public.datum_id_seq;

CREATE SEQUENCE public.datum_id_seq;

ALTER SEQUENCE public.datum_id_seq
    OWNER TO postgres;



-- Table: public.poslednja_izmena


CREATE TABLE public.poslednja_izmena
(
    id integer NOT NULL,
    datum timestamp(4) without time zone,
    CONSTRAINT poslednje_punjenje_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE public.poslednja_izmena
    OWNER to postgres;


-- Table: public.skolska_godina


CREATE TABLE public.skolska_godina
(
    id integer NOT NULL,
    naziv character varying(60) COLLATE pg_catalog."default" NOT NULL,
    CONSTRAINT skolska_godina_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE public.skolska_godina
    OWNER to postgres;

-- Table: public.profil


CREATE TABLE public.profil
(
    id integer NOT NULL,
    naziv character varying(50) COLLATE pg_catalog."default" NOT NULL,
    akronim character varying(50) COLLATE pg_catalog."default" NOT NULL,
    CONSTRAINT profil_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE public.profil
    OWNER to postgres;

-- Table: public.datum


CREATE TABLE public.datum
(
    id integer NOT NULL DEFAULT nextval('datum_id_seq'::regclass),
    datum_vreme date NOT NULL,
    CONSTRAINT datum_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE public.datum
    OWNER to postgres;

-- Table: public.nacin_upisa


CREATE TABLE public.nacin_upisa
(
    id integer NOT NULL,
    naziv character varying(50) COLLATE pg_catalog."default" NOT NULL,
    CONSTRAINT nacin_upisa_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE public.nacin_upisa
    OWNER to postgres;

-- Table: public.uplata


-- Table: public.godina_studija

CREATE TABLE public.godina_studija
(
    id integer NOT NULL,
    naziv character varying(50) COLLATE pg_catalog."default",
    CONSTRAINT godina_studija_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE public.godina_studija
    OWNER to postgres;


-- Table: public.opstina


CREATE TABLE public.opstina
(
    id integer NOT NULL,
    naziv character varying(500) COLLATE pg_catalog."default" NOT NULL,
    drzava character varying COLLATE pg_catalog."default",
    CONSTRAINT opstina_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE public.opstina
    OWNER to postgres;

-- Table: public.mesto

CREATE TABLE public.mesto
(
    id integer NOT NULL,
    naziv character varying(500) COLLATE pg_catalog."default" NOT NULL,
    id_opstina integer,
    CONSTRAINT mesto_pkey PRIMARY KEY (id),
    CONSTRAINT id_opstina_fk FOREIGN KEY (id_opstina)
        REFERENCES public.opstina (id) MATCH SIMPLE
        ON UPDATE NO ACTION
        ON DELETE NO ACTION
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE public.mesto
    OWNER to postgres;

-- Table: public.upis


CREATE TABLE public.upis
(
    id integer NOT NULL,
    id_datum integer,
    id_godina_studija integer,
    id_nacin_upisa integer,
    id_profil integer,
    id_skolska_godina integer,
    id_mesto_stanovanja_studenta integer,
    iznos numeric(10,2),
    CONSTRAINT upis_pkey PRIMARY KEY (id),
    CONSTRAINT upis_id_datum_fkey FOREIGN KEY (id_datum)
        REFERENCES public.datum (id) MATCH SIMPLE
        ON UPDATE NO ACTION
        ON DELETE NO ACTION,
    CONSTRAINT upis_id_godina_studija_fkey FOREIGN KEY (id_godina_studija)
        REFERENCES public.godina_studija (id) MATCH SIMPLE
        ON UPDATE NO ACTION
        ON DELETE NO ACTION,
    CONSTRAINT upis_id_mesto_stanovanja_fkey FOREIGN KEY (id_mesto_stanovanja_studenta)
        REFERENCES public.mesto (id) MATCH SIMPLE
        ON UPDATE NO ACTION
        ON DELETE NO ACTION,
    CONSTRAINT upis_id_nacin_upisa_fkey FOREIGN KEY (id_nacin_upisa)
        REFERENCES public.nacin_upisa (id) MATCH SIMPLE
        ON UPDATE NO ACTION
        ON DELETE NO ACTION,
    CONSTRAINT upis_id_profil_fkey FOREIGN KEY (id_profil)
        REFERENCES public.profil (id) MATCH SIMPLE
        ON UPDATE NO ACTION
        ON DELETE NO ACTION,
    CONSTRAINT upis_id_skolska_godina_fkey FOREIGN KEY (id_skolska_godina)
        REFERENCES public.skolska_godina (id) MATCH SIMPLE
        ON UPDATE NO ACTION
        ON DELETE NO ACTION
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE public.upis
    OWNER to postgres;